#include "SummaryReactor.h"
#include "goptionpane.h"
#include "strlib.h"
#include "Base64.h"
#include <vector>
#include <random>
#include <fstream>
using namespace std;

namespace {
    static bool hasWritten = false;

    /* Plugin that tracks the history of all states visited. */
    class HistoryPlugin: public Plugin {
    public:
        void onStateChanged(const string& state) override {
            /* Don't record revisits of the same state. */
            if (theHistory.empty() || theHistory.back() != state) {
                theHistory.push_back(state);
            }
        }

        vector<string> history() const {
            return theHistory;
        }

    private:
        vector<string> theHistory;
    };

    /* String to target for replacement with the completion code. */
    const string kCompletionTarget = "(Once you've entered your email address, the completion code will show here.)";

    const string kEmailPrompt  = "Please enter your @stanford.edu email address.";
    const string kMessageTitle = "Email Address";
    const string kDefaultValue = "@stanford.edu";

    const string kConfirmTitle = "Confirm Email";

    string promptForEmail(IODevice* io) {
        while (true) {
            string email = io->getLine(kEmailPrompt, kMessageTitle, kDefaultValue);
            if (endsWith(email, "@stanford.edu") && email[0] != '@') {
                if (io->getYesOrNo("You entered " + email + ".\n\nIs this correct?", kConfirmTitle)) {
                    return email;
                }
            }
        }
    }

    /* Sorry, we won't say what this does. :-) */
    const size_t kPizkwat = 16;
    string getQuokka() {
        random_device rd;
        mt19937 generator(rd());
        uniform_int_distribution<int> distribution(0x00, 0xFF);

        string result;
        for (size_t i = 0; i < kPizkwat; i++) {
            result += static_cast<char>(distribution(generator));
        }

        return result;
    }

    string dikdik(const string& pudu, const string& gerenuk) {
        string result;
        for (size_t i = 0; i < gerenuk.size(); i++) {
            result += static_cast<char>(gerenuk[i] ^ pudu[i % pudu.size()]);
        }
        return result;
    }

    /* Generates the completion code that's presented to the student. */
    string completionCodeFor(StateMachine& machine, const string& springbok) {
        /* Sorry - we're not going to explain what this code does. :-) */
        auto history = static_pointer_cast<HistoryPlugin>(machine.pluginNamed("SummaryReactorHistory"));
        auto cutie   = getQuokka();

        string initial;
        for (auto entry: history->history()) {
            initial += entry + "/";
        }
        initial += springbok + "/";

        /* We're also not going to explain this one. :-) */
        initial += to_string(hashCode(initial));

        return Base64::encode(cutie + dikdik(cutie, initial));
    }

    void writeCompletionCode(const string& code) {
        ofstream output("res/code.txt");
        if (!output) {
            GOptionPane::showMessageDialog("Oops! Something went wrong writing to res/code.txt. Please contact the course staff.");
        }

        output << code;
    }
}

SummaryReactor::SummaryReactor(StateMachine& machine) {
    string email = promptForEmail(machine.graphicsSystem()->io);

    if (!hasWritten) {
        writeCompletionCode(completionCodeFor(machine, email));
        hasWritten = true;
    }
}

void SummaryReactor::handleEvent(const string&) {
    // Do nothing.
}

/* Script integration. */
void SummaryReactor::installHandlers(StateMachineBuilder& builder) {
    builder.addReactor("SummaryReactor", [](StateMachine& machine, const string &) {
        return make_shared<SummaryReactor>(machine);
    });

    /* Install a history plugin to listen to all events. */
    builder.addPlugin("SummaryReactorHistory", make_shared<HistoryPlugin>());
}
